//------------------------------------------------------------------------------
// Lab. 04: Obtain the step and impulse response of the state model.
//------------------------------------------------------------------------------

//scilab-5.5.0
//Operating System : OS X 10.9.3

//Clean the environment
clc;
clear all;
clf;

// State space representation
A=[-2 -1; -1 -1];
B=[1;1];
C=[0 2];
D=0;
x0=[0;5]; // Initial condition
sys=syslin('c',A,B,C,D)

// Response to a given input
figure(0)
t=linspace(0,20,1001);
temp=size(t);
u=ones(temp(1),temp(2)); // Exogenous signal(step)
y=csim(u,t,sys,x0) 
plot(t,y)
title('Unit step response of the system','fontsize',4)
xlabel('Time t','fontsize',2)
ylabel('Response y(t)','fontsize',2)

// Response to a given input
figure(1)
t=linspace(0,10,1001);
y=csim('impuls',t,sys)
plot(t,y)
title('Impulse response of the system','fontsize',4)
xlabel('Time t','fontsize',2)
ylabel('Response y(t)','fontsize',2)
